<?php
namespace VM\PackageGeneratorBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use VM\PackageGeneratorBundle\Exceptions\CutterException;

class PackageCreateCommand extends ContainerAwareCommand
{
    private $Container;

    protected function configure()
    {
        $this
            ->setName('package:create')
            ->setDescription('Create multibook package from PDF')
            ->addOption('src', null, InputOption::VALUE_REQUIRED, 'PDF path', null)
            ->addOption('auth-code', null, InputOption::VALUE_REQUIRED, 'Auth CODE', null)
            ->addOption('output', null, InputOption::VALUE_REQUIRED, 'Path to output folder', null)
            ->addOption('type', null, InputOption::VALUE_OPTIONAL, 'Export type: xml, json, mobile', 'xml')
            ->addOption('svn-dir', null, InputOption::VALUE_OPTIONAL, 'SVN dir for mobile export', '')
            ->addOption('title', null, InputOption::VALUE_OPTIONAL, 'Title of the exported product', '')
            ->addOption('only-content', null, InputOption::VALUE_OPTIONAL, 'Only content without exe', true)

        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $path = $input->getOption('src');
        $type = $input->getOption('type');
        $svnDir = $input->getOption('svn-dir');
        $authCode = $input->getOption('auth-code');
        $outputPath = $input->getOption('output');
        $title = $input->getOption('title');
        $onlyContent = $input->getOption('only-content');


        if(empty($authCode))
        {
            throw new \Exception('--auth-code is empty');
        }
        if(empty($outputPath) || !is_dir($outputPath))
        {
            throw new \Exception('--output is not correctly dir');
        }

        $dir = '/var/tmp/abc';

        try
        {
            $ExportProcess = $this->getContainer()->get('vm_package_generator.export.process_creator');
            $ExportProcess->process($path, $authCode, $outputPath, $type, $title, $svnDir, $onlyContent);


        }
        catch(CutterException $Exception)
        {
            $output->writeln('<error>ERROR! ' . $Exception->getMessage() . '</error>');
        }
    }
}